/* Enable element to store data (similar to jQuery). This functionality will be packaged
   into Prototype 1.6.1 so remove the code below when we upgrade.
 */

/* START OF "REMOVE WHEN PROTOTYPE 1.6.1 IS OUT" */
Element.Storage = {
 UID: 1
};

Element.addMethods({
  /**
  *  Element#getStorage(@element) -> Hash
  *  
  *  Returns the [[Hash]] object that stores custom metadata for this element.
  **/
  getStorage: function(element) {
   if (!(element = $(element))) return;

   var uid;
   if (element === window) {
     uid = 0;
   } else {
     if (typeof element._prototypeUID === "undefined")
       element._prototypeUID = [Element.Storage.UID++];
     uid = element._prototypeUID[0];
   }

   if (!Element.Storage[uid])
     Element.Storage[uid] = $H();

   return Element.Storage[uid];
  },

  /**
  *  Element#store(@element, key, value) -> Element
  *  
  *  Stores a key/value pair of custom metadata on the element.
  *  
  *  The metadata can later be retrieved with [[Element.retrieve]].
  **/
  store: function(element, key, value) {
   if (!(element = $(element))) return;

   if (arguments.length === 2) {
     // Assume we've been passed an object full of key/value pairs.
     element.getStorage().update(key);
   } else {
     element.getStorage().set(key, value);
   }

   return element;
  },

  /**
  *  Element#retrieve(@element, key[, defaultValue]) -> ?
  *  
  *  Retrieves custom metadata set on `element` with [[Element.store]].
  *  
  *  If the value is `undefined` and `defaultValue` is given, it will be
  *  stored on the element as its new value for that key, then returned.
  **/
  retrieve: function(element, key, defaultValue) {
   if (!(element = $(element))) return;
   var hash = Element.getStorage(element), value = hash.get(key);

   if (Object.isUndefined(value)) {
     hash.set(key, defaultValue);
     value = defaultValue;
   }

   return value;
  }
});

/* END OF "REMOVE WHEN PROTOTYPE 1.6.1 IS OUT" */

/* Methods which help add a prompt watermark to certain input fields.
   Based on implementation from Josh Goebel: http://pastie.org/109666
   Best feature is it clears the prompt content from the fields before
   submitting the form. To use:
   1) To fields which you want to have a watermark...
      * Add a class of 'watermark'
      * Add a title (this will be used as the content of the watermark)
   2) To ensure the watermarks are removed before the form is submitted
      add the following and onsubmit handler...
      
      <% form_for(@item, :id => 'edit_item', :html => { :onsubmit => "removeWatermarks();" }) do |f| %>
         ...
      <% end %>
*/

Event.observe(window,'load', function() {
  addWatermarks();
});

function addWatermarks() {
  $$('input.watermark').map(function(element) {
    element.setAttribute("autocomplete", "off");
    var form = element.up('form');
    if (form) {
      if (!form.clearOnFocusElements) {
        form.clearOnFocusElements = [];
      }
      form.clearOnFocusElements.push(new ClearOnFocus(element));
    }
    return form;
  })
}

function removeWatermarks() {
  $$('form').map(function(form) {
    if (!form.clearOnFocusElements) {
      return;
    }
    form.clearOnFocusElements.each(function(field) {
      field.removeWatermark(field.element);
    })
  })
}

var ClearOnFocus = Class.create();
Object.extend(ClearOnFocus.prototype, {
  initialize: function(element) {
    this.element = element;
    element.observe('blur', this.onBlur.bind(this));
    element.observe('focus', this.onFocus.bind(this));
    this.removeWatermark.bind(this);
    this.addWatermark.bind(this);

    if ($F(element) == '') {
      this.addWatermark(element);
    }
  },
  removeWatermark: function(field) {
    if ($F(field) == field.title) {
      field.value = '';
      field.removeClassName('clear_on_focus');
    }
  },
  addWatermark: function(field) {
    if ($F(field) == '') {
      field.value = field.title;
      field.addClassName('clear_on_focus');
    }
  },
  onFocus: function(event) {
    this.removeWatermark(event.element());
  },
  onBlur: function(event) {
    this.addWatermark(event.element());
  }
})

/* Methods to help highlight elements during delete & drag/drop */
var hovering = false;

function elementMouseOver(childElement) {
  if (!hovering) {
    hovering = true;
    $(childElement).up('.element').addClassName('highlight_element');
  }
}

function elementMouseOut(childElement) {
  if (hovering) {
    hovering = false;
    $(childElement).up('.element').removeClassName('highlight_element');
  }
}

// Taken, with thanks, from:
// http://www.netshinesoftware.com/component/option,com_myblog/Itemid,65/show,Rounding-Numbers-in-Javascript.html/
function round_number(number, dec_places)
{
  // (c) Copyright 2008, Russell Walker, Netshine Software Limited. www.netshinesoftware.com   
  // Version 2.0. Change log:
  // 18/12/08 Fixed bug where digits after decimal point greater than 995
  // 29/01/09 Added support for negative numbers (symmetrical rounding) and strip white space
  // 12/03/09 Fixed bug where first digit is a 9 and needs to be rounded up
  var new_number = '';
  var i = 0;                            // Just used in loops
  var sign = "";                        // If negative, a minus sign will be prefixed to the result
  number = number.toString();           // We need to operate on and return a string, not a number
  number = number.replace(/^\s+|\s+$/g, ''); // Remove any excess white space
  
  //Do we have a negative number?
  if (number.charCodeAt(0) == 45) {     // minus sign
    sign = '-';
    number = number.substr(1).replace(/^\s+|\s+$/g, '');
  }
  
  dec_places = dec_places * 1;          //We need an integer
  dec_point_pos = number.lastIndexOf(".");
  
  // If there is nothing before the decimal point, prefix with a zero
  if (dec_point_pos == 0) {
    number = "0" + number;
    dec_point_pos = 1;
  }
  
  // Has an integer been passed in?
  if (dec_point_pos == -1 || dec_point_pos == number.length - 1) {
    if (dec_places > 0) {
      new_number = number + ".";
      for (i=0; i<dec_places; i++) {
        new_number += "0";
      }
      
      if (new_number == 0) {
        sign = "";
      }
      return sign + new_number;
    }
    else {
      return sign + number;
    }
  }

  // Do we already have the right number of decimal places?
  var existing_places = (number.length - 1) - dec_point_pos;
  if (existing_places == dec_places) {
    return sign + number; //If so, just return the input value
  }
  
  // Do we already have less than the number of decimal places we want?
  if (existing_places < dec_places) {
    // If so, pad out with zeros
    new_number = number;
    for (i=existing_places; i<dec_places; i++) {
      new_number += "0";
    }
    if (new_number == 0) {
      sign = "";
    }
    return sign + new_number;
  }

  // Work out whether to round up or not
  var end_pos = (dec_point_pos * 1) + dec_places;
  var round_up = false;                 //Whether or not to round up (add 1 to) the next digit along
  if ((number.charAt(end_pos + 1) * 1) > 4) {
    round_up = true;
  }
  
  // Record each digit in an array for easier manipulation
  var digit_array = new Array();
  for (i=0; i<=end_pos; i++) {
    digit_array[i] = number.charAt(i);
  }
  
  // Round up the last digit if required, and continue until no more 9's are found
  for (i=digit_array.length - 1; i>=0; i--) {
    if (digit_array[i] == ".") {
      continue;
    }
    if (round_up) {
      digit_array[i]++;
      if (digit_array[i] < 10) {
        break;
      }
    } else {
      break;
    }
  }
  
  // Reconstruct the string, converting any 10's to 0's (except for first digit which can stay as a 10)
  for (i=0; i<=end_pos; i++) {
    if (digit_array[i] == "." || digit_array[i] < 10 || i == 0) {
      new_number += digit_array[i];
    } else {
      new_number += "0";
    }
  }
  
  // If there are no decimal places, we don't need a decimal point
  if (dec_places == 0) {
    new_number = new_number.replace(".", "");
  }
  
  if (new_number == 0) {
    sign = "";
  }
  
  //That should do it!
  return sign + new_number;
}

function MM_findObj(n, d) { //v4.01
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && d.getElementById) x=d.getElementById(n); return x;
}

function MM_validateForm() { //v4.0
  var i,p,q,nm,test,num,min,max,errors='',args=MM_validateForm.arguments;
  for (i=0; i<(args.length-2); i+=3) { test=args[i+2]; val=MM_findObj(args[i]);
    if (val) { nm=val.name; if ((val=val.value)!="") {
      if (test.indexOf('isEmail')!=-1) { p=val.indexOf('@');
        if (p<1 || p==(val.length-1)) errors+='- '+nm+' must contain an e-mail address.\n';
      } else if (test!='R') { num = parseFloat(val);
        if (isNaN(val)) errors+='- '+nm+' must contain a number.\n';
        if (test.indexOf('inRange') != -1) { p=test.indexOf(':');
          min=test.substring(8,p); max=test.substring(p+1);
          if (num<min || max<num) errors+='- '+nm+' must contain a number between '+min+' and '+max+'.\n';
    } } } else if (test.charAt(0) == 'R') errors += '- '+nm+' is required.\n'; }
  } if (errors) alert('The following error(s) occurred:\n'+errors);
  document.MM_returnValue = (errors == '');
}