
	// HELPER CLASS TO GET WINDOW DIMENSIONS ---------------------------
	Window = {
		getHeight: function(){
			return (window.innerHeight) ? (window.innerHeight) : (document.documentElement.clientHeight);
		},

		getWidth: function(){
			return (window.innerWidth) ? (window.innerWidth) : (document.documentElement.clientWidth);
		},

		getYScroll: function(){
			return (self.pageYOffset) ? (self.pageYOffset) : (document.documentElement.scrollTop);
		},

		getXScroll: function(){
			return (self.pageXOffset) ? (self.pageXOffset) : (document.documentElement.scrollLeft);
		},

		create: function(options){
			// Set the default options
			this.options = {
				url: 'about:blank',
				name: '_blank',			// Optional. The name of the window
				specs: {},					// Optional. Pass in the options as an object. http://www.w3schools.com/HTMLDOM/met_win_open.asp
				centered: true,
				replace: false			// Specifies whether the URL creates a new entry or replaces the current entry in the history list.
			};
		
			// Extend the object with the passed in options
			jQuery.extend(this.options, options);
		
			// Center the window too
			if (this.options.centered){
				jQuery.extend(this.options.specs, {
					left: (this.getWidth() - parseInt(this.options.specs.width)) / 2 + 'px',
					top: (this.getHeight() - parseInt(this.options.specs.height)) / 2 + 'px'
				});
			}
		
			// Open the window
			this.newWindow = window.open(this.options.url,
				this.options.name,
				jQuery.param(this.options.specs).gsub(/\&/, ','),
				this.options.replace);
			
			// Bring the window into focus
			this.newWindow.focus();
		}
	};

	// HELPER CLASS TO GET DOCUMENT DIMENSIONS -------------------------
	Document = {
		getHeight: function(){
			var scrollHeight = (window.innerHeight && window.scrollMaxY) ?
				(window.innerHeight + window.scrollMaxY) :
				(document.body.offsetHeight);
		
			var windowHeight = (window.innerHeight) ? (window.innerHeight) : (document.documentElement.clientHeight);
	
			return (scrollHeight < windowHeight) ? (windowHeight) : (scrollHeight);
		},

		getWidth: function(){
			var scrollWidth = (window.innerHeight && window.scrollMaxY) ?
				(document.body.scrollWidth) :
				(document.body.offsetWidth);
		
			var windowWidth = (window.innerWidth) ? (window.innerWidth) : (document.documentElement.clientWidth);
		
			return (scrollWidth < windowWidth) ? (windowWidth) : (scrollWidth);
		}
	};

	// HELPER CLASS TO CREATE & READ COOKIES -------------------------
	var Cookie = {
		set: function(name, value, nDays, domain, path, secure){
			var expires = new Date();
			expires.setTime(Date.parse(expires) + (3600000 * 24 * nDays));
		
			document.cookie = name + "=" + escape(value) +
				((expires) ? ";expires=" + expires.toGMTString() : "") + 
				((path) ? ";path=" + path : "/") + 
				((domain) ? ";domain=" + domain : "") +
				((secure) ? ";secure" : "");
		},
	
		update: function(name, value, nDays, domain, path, secure){
			this.set(name, value, nDays, domain, path, secure);
		},

		get: function(cookieName){
			var results = document.cookie.match('(^|;) ?' + cookieName + '=([^;]*)(;|$)');
			return (results) ? (unescape(results[2])) : (null);
		},
	
		destroy: function(cookieName){
			document.cookie = cookieName + "=; expires=" + new Date().getTime() * -9999999999999+'; path=/';
		}
	};

	// HELPER CLASS FOR JAVASCRIPT INTEGERS -----------------------------
	Integer = {
		addCommas: function(nStr){
			nStr += '';
			x = nStr.split('.');
			x1 = x[0];
			x2 = x.length > 1 ? '.' + x[1] : '';
			var rgx = /(\d+)(\d{3})/;
			while (rgx.test(x1)) {
				x1 = x1.replace(rgx, '$1' + ',' + '$2');
			}
			return x1 + x2;
		}
	};
