$(document).observe('dom:loaded', function(){

	var textboxes = $$('form.awesome input.input-text');

	textboxes.each(function(input, index){
		
		var label = input.previous();
	
		if (index == 0){
			new Form.Observer(input.up('form'), 0.1, function(form, value) {
				textboxes.each(function(inputX){
					if (!inputX.value.empty()) {
						inputX.previous().addClassName('hastext');
					}
				});
			});
		}
		
		input.onfocus = function(){
			if (input.value.empty()){
				label.addClassName('focus');            
			}
		}
		input.onblur = function(){
			if (input.value.empty()){
				label.removeClassName('focus').removeClassName('hastext');          
			}
		}
		
		if (!input.value.empty()) {
			label.addClassName('hastext');
		}
		
		input.onkeypress = function(){
			label.addClassName('hastext');
		};
	});

});